/* 
 * pthread_create.c 
 *
 * Створює потік, який у безкінечному циклі виводить символи x. 
 * Батьківський потік при цьому в безкінечному циклі виводить символи o.
 * Ілюструє порядок створення потоків (функція pthread_create()).
 *
 */

#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

void *print_xs(void *unused);


/* Потокова функція */
void *print_xs(void *unused)
{
        /* У безкінечному циклі виводить у стандартний потік виведення
           повідомлень про помилки символи x. */
        while (1)
                fputc('x', stderr);
        return NULL;	
}

int main()
{
        pthread_t thread_id;
        int terrno;

        /* Створює потік. Новий потік виконує функцію print_xs(). */
        terrno = pthread_create(&thread_id, NULL, &print_xs, NULL);
        if (terrno != 0) {
                fprintf(stderr, "Error creating thread: %s\n",
                                                strerror(terrno));
                exit(EXIT_FAILURE);
        }

        /* У безкінечному циклі виводить у стандартний потік виведення
           повідомлень про помилки символи o. */
        while (1)
                fputc('o', stderr);

        return EXIT_SUCCESS;
}
